rule Win64_Backdoor_Konni : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "KONNI"
        description         = "Yara rule that detects Konni backdoor."

        tc_detection_type   = "Backdoor"
        tc_detection_name   = "Konni"
        tc_detection_factor = 5

    strings:

        $network_communication_p1 = {
            48 8B C4 53 55 57 41 54 41 55 41 56 41 57 48 83 EC ?? 48 8B 3D ?? ?? ?? ?? 45 33 FF
            48 8B D9 4C 8D A7 ?? ?? ?? ?? 33 D2 41 B8 ?? ?? ?? ?? 49 8B CC 44 89 78 ?? 44 89 78
            ?? 45 8B F7 44 89 78 ?? 41 8B EF E8 ?? ?? ?? ?? 4C 8D 8F ?? ?? ?? ?? 4C 8D 05 ?? ??
            ?? ?? BA ?? ?? ?? ?? 49 8B CC 48 89 5C 24 ?? 48 89 7C 24 ?? E8 ?? ?? ?? ?? 48 8D 9F
            ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 41 BD ?? ?? ?? ?? 45 33 C9 45 33 C0 33 C9 41 8B
            D5 44 89 7C 24 ?? FF 15 ?? ?? ?? ?? 48 8B F8 48 89 44 24 ?? 48 85 C0 75 ?? 83 C8 ??
            48 83 C4 ?? 41 5F 41 5E 41 5D 41 5C 5F 5D 5B C3 4C 89 7C 24 ?? 44 89 7C 24 ?? 41 B8
            ?? ?? ?? ?? 45 33 C9 48 8B D3 48 8B C8 C7 44 24 ?? ?? ?? ?? ?? 48 89 B4 24 ?? ?? ??
            ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 4C 89 7C 24 ?? FF 15 ?? ?? ?? ?? 48 8B F0 48 85
            C0 0F 84 ?? ?? ?? ?? 4C 89 7C 24 ?? C7 44 24 ?? ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 45
            33 C9 4D 8B C4 48 8B C8 4C 89 7C 24 ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 4C 89 7C 24
            ?? FF 15 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 ?? 45 33 C9 45 33 C0 33 D2 48 8B C8 44 89
            7C 24 ?? FF 15 ?? ?? ?? ?? 45 33 C9 45 33 C0 48 8B CB 85 C0 74 ?? 48 8D 94 24 ?? ??
            ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? 45 33 C9 48 8B CB 45 33 C0 33 D2 FF 15 ?? ?? ??
            ?? 48 8B CB FF 15 ?? ?? ?? ?? 48 8B CE FF 15 ?? ?? ?? ?? 48 8B CF FF 15 ?? ?? ?? ??
            41 8B C5 E9 ?? ?? ?? ?? 8B 84 24 ?? ?? ?? ?? 85 C0 75 ?? 48 8B CB EB ?? FF C0 B9 ??
            ?? ?? ?? 8B D0 89 84 24 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 4C 8B E0 48 85 C0 74 ?? 44 8B
        }

        $network_communication_p2 = {
            84 24 ?? ?? ?? ?? 33 D2 48 8B C8 E8 ?? ?? ?? ?? 45 33 C9 4C 89 7C 24 ?? 48 8D 0D ??
            ?? ?? ?? 45 8D 41 ?? BA ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ??
            FF 15 ?? ?? ?? ?? 4C 8B E8 48 8B CB 48 83 F8 ?? 75 ?? 45 33 C9 45 33 C0 33 D2 FF 15
            ?? ?? ?? ?? 48 8B CB FF 15 ?? ?? ?? ?? 48 8B CE FF 15 ?? ?? ?? ?? 48 8B CF FF 15 ??
            ?? ?? ?? 83 C8 ?? E9 ?? ?? ?? ?? 44 8B 84 24 ?? ?? ?? ?? 4C 8D 8C 24 ?? ?? ?? ?? 49
            8B D4 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? BF ?? ?? ?? ?? 0F 1F 00 44 39 BC 24
            ?? ?? ?? ?? 74 ?? 48 8D 15 ?? ?? ?? ?? 49 8B CC 41 8B EF E8 ?? ?? ?? ?? 48 85 C0 0F
            45 EF 3B EF 74 ?? 44 8B 84 24 ?? ?? ?? ?? 4C 8D 8C 24 ?? ?? ?? ?? 49 8B D4 49 8B CD
            4C 89 7C 24 ?? FF 15 ?? ?? ?? ?? 44 8B 84 24 ?? ?? ?? ?? 44 03 B4 24 ?? ?? ?? ?? 33
            D2 49 8B CC E8 ?? ?? ?? ?? 44 8B 84 24 ?? ?? ?? ?? 4C 8D 8C 24 ?? ?? ?? ?? 49 8B D4
            48 8B CB FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 48 8B 7C 24 ?? 49 8B CD FF 15 ??
            ?? ?? ?? 49 8B CC FF 15 ?? ?? ?? ?? 45 33 C9 45 33 C0 33 D2 48 8B CB FF 15 ?? ?? ??
            ?? 48 8B CB FF 15 ?? ?? ?? ?? 48 8B CE FF 15 ?? ?? ?? ?? 48 8B CF FF 15 ?? ?? ?? ??
            83 C8 ?? 45 85 F6 0F 44 E8 8B C5 48 8B B4 24 ?? ?? ?? ?? 48 83 C4 ?? 41 5F 41 5E 41
            5D 41 5C 5F 5D 5B C3
        }

        $handle_c2_commands_p1 = {
            48 89 5C 24 ?? 48 89 74 24 ?? 57 48 81 EC ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 33 C4
            48 89 84 24 ?? ?? ?? ?? 48 8D 35 ?? ?? ?? ?? 48 8D 54 24 ?? 33 FF 48 8B CE 89 7C 24
            ?? FF 15 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 ?? 83 C8 ?? E9 ?? ?? ?? ?? 48 8B 15 ?? ??
            ?? ?? 48 8B 08 E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 8B 4B
            ?? E8 ?? ?? ?? ?? 85 C0 75 ?? 48 8B 4B ?? 48 8D 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0
            75 ?? 48 8B 4B ?? 8D 50 ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 48 8D 4C 24 ?? 33 D2 41 B8
            ?? ?? ?? ?? 66 89 7C 24 ?? E8 ?? ?? ?? ?? 48 8B 4B ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ??
            48 8B 15 ?? ?? ?? ?? 48 8B 4B ?? E8 ?? ?? ?? ?? 85 C0 75 ?? 48 8B 53 ?? 48 8D 0D ??
            ?? ?? ?? 45 33 C0 FF 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? E9 ?? ??
            ?? ?? 48 8B 15 ?? ?? ?? ?? 48 8B 4B ?? E8 ?? ?? ?? ?? 85 C0 75 ?? 48 8B 4B ?? E8 ??
            ?? ?? ?? 69 C0 ?? ?? ?? ?? 89 05 ?? ?? ?? ?? E9 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48
            8B 4B ?? E8 ?? ?? ?? ?? 85 C0 75 ?? 48 8B 4B ?? E8 ?? ?? ?? ?? 69 C0 ?? ?? ?? ?? 89
        }

        $handle_c2_commands_p2 = {
            05 ?? ?? ?? ?? E9 ?? ?? ?? ?? 48 63 4C 24 ?? 48 8D 15 ?? ?? ?? ?? 48 8B 4C CB ?? E8
            ?? ?? ?? ?? 48 8B CE 85 C0 75 ?? 8D 50 ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 33 D2 E8 ??
            ?? ?? ?? E9 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 8B 0B E8 ?? ?? ?? ?? 48 63 4C 24 ??
            48 8B 15 ?? ?? ?? ?? 48 8B 4C CB ?? 85 C0 75 ?? E8 ?? ?? ?? ?? 85 C0 74 ?? 48 63 4C
            24 ?? 48 8D 15 ?? ?? ?? ?? 48 8B 4C CB ?? E8 ?? ?? ?? ?? 85 C0 74 ?? 48 8B 3B 48 83
            C9 ?? 33 C0 66 F2 AF 33 D2 48 F7 D1 48 8D 0C 4E E8 ?? ?? ?? ?? EB ?? 48 8B 3B 48 83
            C9 ?? 33 C0 66 F2 AF 8D 50 ?? 48 F7 D1 48 8D 0C 4E E8 ?? ?? ?? ?? EB ?? E8 ?? ?? ??
            ?? 85 C0 75 ?? 8D 48 ?? EB ?? 33 C9 E8 ?? ?? ?? ?? 8B F8 48 8B CB FF 15 ?? ?? ?? ??
            8B C7 48 8B 8C 24 ?? ?? ?? ?? 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 ?? ?? ?? ?? 49 8B
            5B ?? 49 8B 73 ?? 49 8B E3 5F C3
        }

        $create_cab_file_and_upload_p1 = {
            48 89 5C 24 ?? 55 56 57 41 54 41 57 48 8D AC 24 ?? ?? ?? ?? 48 81 EC ?? ?? ?? ?? 48
            8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 ?? ?? ?? ?? 4C 8B 3D ?? ?? ?? ?? 33 DB 48 8B F1
            48 8D 4D ?? 33 D2 41 B8 ?? ?? ?? ?? 44 8B E3 89 5C 24 ?? 89 5C 24 ?? 66 89 5D ?? E8
            ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? 33 D2 41 B8 ?? ?? ?? ?? 66 89 9D ?? ?? 00 00 E8 ??
            ?? ?? ?? 33 C0 48 8D 4C 24 ?? 66 89 5C 24 ?? 48 89 44 24 ?? 89 44 24 ?? 66 89 44 24
            ?? FF 15 ?? ?? ?? ?? 0F B7 54 24 ?? 0F B7 4C 24 ?? 44 0F B7 44 24 ?? 0F B7 44 24 ??
            0F B7 7C 24 ?? 89 54 24 ?? 89 44 24 ?? 89 4C 24 ?? 89 7C 24 ?? 44 89 44 24 ?? 4C 8D
            05 ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ??
            ?? 48 8D 4D ?? 33 D2 41 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 55 ?? B9 ?? ?? ?? ?? FF
            15 ?? ?? ?? ?? 4C 8D 4D ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D ?? 45 33 C0 FF 15 ?? ?? ??
            ?? 48 8D 4D ?? FF 15 ?? ?? ?? ?? 8D 53 ?? 48 8B CE E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ??
            ?? 48 8B C8 48 8B F8 E8 ?? ?? ?? ?? 85 C0 74 ?? 48 8D 15 ?? ?? ?? ?? 48 8B CF E8 ??
            ?? ?? ?? 85 C0 74 ?? 48 8D 15 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 85 C0 74 ?? 48 8D
            15 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 85 C0 74 ?? 48 8D 15 ?? ?? ?? ?? 48 8B CF E8
            ?? ?? ?? ?? 85 C0 74 ?? 48 8D 15 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 85 C0 74 ?? 48
        }

        $create_cab_file_and_upload_p2 = {
            8D 4D ?? 48 8B D6 E8 ?? ?? ?? ?? 83 F8 ?? 75 ?? 0B C0 E9 ?? ?? ?? ?? 48 8D 55 ?? 45
            33 C0 48 8B CE FF 15 ?? ?? ?? ?? 45 33 C9 48 89 5C 24 ?? 48 8D 4D ?? 45 8D 41 ?? BA
            ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 4C 89 AC 24 ?? ?? ?? ?? 89 5C 24 ?? C7 44 24 ??
            ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B F8 48 83 F8 ?? 75 ?? 8B C3 EB ?? 33 D2 48 8B C8
            FF 15 ?? ?? ?? ?? 8B F0 85 C0 75 ?? 48 8B CF FF 15 ?? ?? ?? ?? 8B C3 EB ?? FF C6 B9
            ?? ?? ?? ?? 8B D6 44 8B EE FF 15 ?? ?? ?? ?? 4C 8B E0 48 85 C0 75 ?? 48 8B CF FF 15
            ?? ?? ?? ?? 8B C3 EB ?? 4D 8B C5 33 D2 48 8B C8 E8 ?? ?? ?? ?? 4C 8D 4C 24 ?? 44 8B
            C6 49 8B D4 48 8B CF 48 89 5C 24 ?? FF 15 ?? ?? ?? ?? 48 8B CF FF 15 ?? ?? ?? ?? 8B
            44 24 ?? 89 44 24 ?? 85 C0 75 ?? 83 C8 ?? E9 ?? ?? ?? ?? 48 8D 4D ?? 4C 89 B4 24 ??
            ?? ?? ?? FF 15 ?? ?? ?? ?? 44 8B 6C 24 ?? B9 ?? ?? ?? ?? 41 83 C5 ?? 41 8B FD 41 8B
            D5 48 89 7C 24 ?? FF 15 ?? ?? ?? ?? 4C 8B F0 48 85 C0 0F 84 ?? ?? ?? ?? 44 8B C7 33
            D2 48 8B C8 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 74 ?? 33
            C0 48 83 C9 ?? 4C 8D 86 ?? ?? ?? ?? 48 8D BD ?? ?? ?? ?? 66 F2 AF 49 89 00 49 89 40
            ?? 48 F7 D1 49 89 40 ?? 49 89 40 ?? 48 FF C9 03 C9 74 ?? 8B D1 48 8D 8D ?? ?? ?? ??
            E8 ?? ?? ?? ?? EB ?? 48 8B F3 49 89 B7 ?? ?? ?? ?? 48 85 F6 0F 84 ?? ?? ?? ?? 44 8B
        }

        $create_cab_file_and_upload_p3 = {
            44 24 ?? 4D 8B CE 49 8B D4 48 8B CE 44 89 6C 24 ?? E8 ?? ?? ?? ?? 49 8B 8F ?? ?? ??
            ?? 48 85 C9 74 ?? E8 ?? ?? ?? ?? 49 8B CC 49 89 9F ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48
            83 C9 ?? 33 C0 48 8D BD ?? ?? ?? ?? 66 F2 AF 48 F7 D1 41 8D 84 4D ?? ?? ?? ?? B9 ??
            ?? ?? ?? 8B D0 89 44 24 ?? FF 15 ?? ?? ?? ?? 4C 8B E8 48 85 C0 0F 84 ?? ?? ?? ?? 44
            8B 44 24 ?? 33 D2 48 8B C8 E8 ?? ?? ?? ?? 8B 54 24 ?? 4C 8D 8D ?? ?? ?? ?? 4C 8D 05
            ?? ?? ?? ?? 49 8B CD E8 ?? ?? ?? ?? 48 8B 7C 24 ?? 49 8B D6 8B C8 4C 8B C7 89 44 24
            ?? 49 03 CD E8 ?? ?? ?? ?? 8B 4C 24 ?? 48 8D 15 ?? ?? ?? ?? 48 03 CF 41 B8 ?? ?? ??
            ?? 49 03 CD E8 ?? ?? ?? ?? 49 8B CE FF 15 ?? ?? ?? ?? 49 8D 8F ?? ?? ?? ?? E8 ?? ??
            ?? ?? 45 33 C9 45 33 C0 41 8D 51 ?? 33 C9 89 5C 24 ?? FF 15 ?? ?? ?? ?? 48 8B F0 48
            85 C0 0F 84 ?? ?? ?? ?? 48 89 5C 24 ?? 89 5C 24 ?? 49 8D 97 ?? ?? ?? ?? 41 B8 ?? ??
            ?? ?? 45 33 C9 48 8B C8 C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 48 89 5C 24
            ?? FF 15 ?? ?? ?? ?? 4C 8B E0 48 85 C0 0F 84 ?? ?? ?? ?? 49 8D 8F ?? ?? ?? ?? 33 D2
            41 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4D 8D 8F ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 49 8D 8F
            ?? ?? ?? ?? BA ?? ?? ?? ?? 4C 89 7C 24 ?? E8 ?? ?? ?? ?? 48 89 5C 24 ?? C7 44 24 ??
            ?? ?? ?? ?? 4D 8D 87 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 45 33 C9 49 8B CC 48 89 5C 24
            ?? C7 44 24 ?? ?? ?? ?? ?? 48 89 5C 24 ?? FF 15 ?? ?? ?? ?? 48 8B F8 48 85 C0 74
        }

        $create_cab_file_and_upload_p4 = {
            8B 44 24 ?? 48 8D 15 ?? ?? ?? ?? 4D 8B CD 41 B8 ?? ?? ?? ?? 48 8B CF 89 44 24 ?? FF
            15 ?? ?? ?? ?? 85 C0 74 ?? 49 8B CD FF 15 ?? ?? ?? ?? 48 8D 54 24 ?? 45 33 C9 45 33
            C0 48 8B CF FF 15 ?? ?? ?? ?? 85 C0 75 ?? 45 33 C9 45 33 C0 33 D2 48 8B CF FF 15 ??
            ?? ?? ?? 48 8B CF FF 15 ?? ?? ?? ?? 49 8B CC FF 15 ?? ?? ?? ?? 48 8B CE FF 15 ?? ??
            ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 8B 44 24 ?? 85 C0 74 ?? FF C0 B9 ?? ?? ?? ?? 8B
            D0 89 44 24 ?? FF 15 ?? ?? ?? ?? 4C 8B E8 48 85 C0 75 ?? 45 33 C9 45 33 C0 33 D2 48
            8B CF FF 15 ?? ?? ?? ?? 48 8B CF FF 15 ?? ?? ?? ?? 49 8B CC FF 15 ?? ?? ?? ?? 48 8B
            CE FF 15 ?? ?? ?? ?? 83 C8 ?? EB ?? 44 8B 44 24 ?? 33 D2 48 8B C8 E8 ?? ?? ?? ?? 44
            8B 44 24 ?? 4C 8D 4C 24 ?? 49 8B D5 48 8B CF FF 15 ?? ?? ?? ?? 85 C0 74 ?? 48 8D 15
            ?? ?? ?? ?? 49 8B CD E8 ?? ?? ?? ?? EB ?? BB ?? ?? ?? ?? 49 8B CD FF 15 ?? ?? ?? ??
            45 33 C9 45 33 C0 33 D2 48 8B CF FF 15 ?? ?? ?? ?? 48 8B CF FF 15 ?? ?? ?? ?? 49 8B
            CC FF 15 ?? ?? ?? ?? 48 8B CE FF 15 ?? ?? ?? ?? 8B C3 4C 8B B4 24 ?? ?? ?? ?? 4C 8B
            AC 24 ?? ?? ?? ?? 48 8B 8D ?? ?? ?? ?? 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ??
            ?? 48 81 C4 ?? ?? ?? ?? 41 5F 41 5C 5F 5E 5D C3
        }

        $cmd_expand_payload_p1 = {
            40 53 55 41 55 48 81 EC ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 ?? ??
            ?? ?? 48 8B E9 48 8D 8C 24 ?? ?? ?? ?? 45 33 ED 33 D2 41 B8 ?? ?? ?? ?? 66 44 89 AC
            24 ?? ?? 00 00 E8 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? 33 D2 41 B8 ?? ?? ?? ?? 66 44
            89 AC 24 ?? ?? 00 00 E8 ?? ?? ?? ?? 45 8D 45 ?? 48 8D 4C 24 ?? 33 D2 44 89 6C 24 ??
            E8 ?? ?? ?? ?? 33 C0 4C 89 6C 24 ?? 45 8D 45 ?? 45 33 C9 BA ?? ?? ?? ?? 48 8B CD C7
            44 24 ?? ?? ?? ?? ?? 4C 89 6C 24 ?? 48 89 44 24 ?? 48 89 44 24 ?? C7 44 24 ?? ?? ??
            ?? ?? FF 15 ?? ?? ?? ?? 48 8B D8 48 83 F8 ?? 75 ?? 0B C0 E9 ?? ?? ?? ?? 45 33 C9 33
            D2 48 8B C8 45 8D 41 ?? 4C 89 6C 24 ?? 48 89 BC 24 ?? ?? ?? ?? 44 89 6C 24 ?? FF 15
            ?? ?? ?? ?? 48 8B F8 48 85 C0 75 ?? 48 8B CB FF 15 ?? ?? ?? ?? 83 C8 ?? E9 ?? ?? ??
            ?? 45 33 C9 45 33 C0 48 8B C8 41 8D 51 ?? 48 89 B4 24 ?? ?? ?? ?? 4C 89 6C 24 ?? FF
            15 ?? ?? ?? ?? 48 8B F0 48 85 C0 75 ?? 48 8B CB FF 15 ?? ?? ?? ?? 83 C8 ?? E9 ?? ??
            ?? ?? 4C 8D 40 ?? 48 8D 84 24 ?? ?? ?? ?? 41 83 C9 ?? 33 D2 33 C9 C7 44 24 ?? ?? ??
            ?? ?? 48 89 44 24 ?? 4C 89 A4 24 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ??
            33 D2 41 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? B9 ?? ?? ?? ?? FF 15 ??
            ?? ?? ?? 4C 8D 84 24 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? BA ?? ?? ?? ?? E8
        }

        $cmd_expand_payload_p2 = {
            44 8B 66 ?? 48 8B CE FF 15 ?? ?? ?? ?? 48 8B CF FF 15 ?? ?? ?? ?? 48 8B CB FF 15 ??
            ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? 33 D2 41 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 8D 05 ??
            ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? 4C 8B CD BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 44 24
            ?? 48 8D 94 24 ?? ?? ?? ?? 48 89 44 24 ?? 48 8D 44 24 ?? 45 33 C9 48 89 44 24 ?? 4C
            89 6C 24 ?? 4C 89 6C 24 ?? 45 33 C0 33 C9 C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ??
            ?? ?? 66 44 89 AC 24 ?? ?? 00 00 44 89 6C 24 ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? 83 C8
            ?? EB ?? 90 B9 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 45 33 C9 4C 89 6C 24 ?? 48 8D 0D ?? ??
            ?? ?? 45 8D 41 ?? BA ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? FF
            15 ?? ?? ?? ?? 48 8B D8 48 83 F8 ?? 75 ?? FF 15 ?? ?? ?? ?? 83 F8 ?? 75 ?? 48 8B CB
            FF 15 ?? ?? ?? ?? 41 8B C4 4C 8B A4 24 ?? ?? ?? ?? 48 8B B4 24 ?? ?? ?? ?? 48 8B BC
            24 ?? ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ?? 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ??
            41 5D 5D 5B C3
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($network_communication_p*)
        ) and
        (
            all of ($handle_c2_commands_p*)
        ) and
        (
            all of ($create_cab_file_and_upload_p*)
        ) and
        (
            all of ($cmd_expand_payload_p*)
        )
}